--[[---------------------------------------------------------------------------
	Chocolatier Two Ledger: Factories
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local fh = bsgFontHeight(smallDialogFont)

local factories = { "sf_factory","ny_factory","pa_factory","ma_factory","sh_factory","syd_factory" }

-- Important constants
local ingColWidth = 13		-- Constant size of ingredient/width of column area
local ingColHeight = 55		-- Constant height of column
local ingY = fh				-- Top of ingredient column
local ingOffsetY = 8		-- Offset for icon spacing

local weeksPerColumn = LFactory.weeksPerColumn[gSim.rank + 1]

local facCount = 6			-- Constant: number of factories
local facColWidth = 83		-- Constant: width of one factory column
local facY = ingColHeight + 15
local facH = ui.ledgerHeight - facY

local iconX = facColWidth / 2

-- Layout information
local columnTable = {}		-- Ingredient status rects
local facTable = {}			-- Factory info
local machineTable = {}		-- Machine info
local productTable = {}		-- Product anim info

for i,fName in ipairs(factories) do
	local f = LBuilding:ByName(fName)
	local fx = facColWidth * (i-1)

	if f.owned then
		local p = f.product
		
		if f.rate > 0 then
			f.idle = false
			local ix = fx + (facColWidth - p.recipeSize * ingColWidth) / 2
			for ing,count in pairs(f.product.recipe) do
				local item = LItem:ByName(ing)
				local weeks = item.inventory / LFactory.globalNeeds[ing]
				if item.inventory < count or weeks == 0 then f.idle = true end
				local percentage = weeks / weeksPerColumn
				local y = ingY + bsgFloor(ingColHeight - ingColHeight * percentage)
				if y < ingY then y = ingY end
				for i=1,count do
					table.insert(facTable, Bitmap { x=ix,y=y, image="item/"..item.name, scale=ingColWidth/32 })
--					if item.inventory < count then
--						table.insert(facTable, Bitmap { x=ix+2,y=y, image="image/missed_ingredient", scale=ingColWidth/43 })
--					end
					
					-- Collect column data for drawing
					table.insert(columnTable, { ix+4, ingY+ingOffsetY, ix+ingColWidth-4, ingY+ingOffsetY+ingColHeight, percentage })
					
					ix = ix + ingColWidth
				end
			end
		end
		
		local rate = f.rate or 0
--		local facIcon = "image/factory.xml"
--		if f.rate == 0 or f.idle then facIcon = "image/factory_idle.xml" end
--		local prodIcon = "item/"..p.name

		local machineIcon = "image/machine_"..p.type.name.."_small"
		
		local rolldY = 13 + ingColHeight / 2
		local rollY = facY - rolldY
		table.insert(facTable,
			Text { x=fx,y=0,w=facColWidth,h=fh, label=LabelString(f.port.name), flags=kHAlignCenter+kVAlignTop })
		
		local perweek = "#"..tostring(rate).." "..GetString("perweek")
		
		local r = 			
		{
--			x=fx,y=rollY, w=facColWidth,h=facH, contents=f:InfoRolloverTarget(),
--			command = function() local f=f if gSim.port == f.port then f:OnActivate() end end,
--			Text { x=0,y=rolldY,w=kMax,h=fh, label=LabelString(f.port.name), flags=kHAlignCenter+kVAlignTop },
--			Sprite { x=iconX,y=fh+12+rolldY, w=32,h=32, image=facIcon },
--			Text { x=0,y=fh+12+rolldY-24,w=iconX-12,h=64, label="#"..tostring(rate).." per week" },

			x=fx,y=0, w=facColWidth,h=facH, contents=f:InfoRolloverTarget(),
--			Text { x=0,y=fh+12+facY-16,w=iconX-16,h=32, label=perweek },
			Text { x=0,y=fh+12+facY-16,w=iconX-16,h=32, label=tostring(rate) },
		}
		if rate > 0 then table.insert(r, Bitmap { x=iconX-16,y=facH-32+rolldY, w=32,h=32, image=prodIcon }) end
		table.insert(facTable, Rollover(r) )
		
		local x = fx + iconX
		local y = fh + rollY + 12 + rolldY
--		table.insert(machineTable, Sprite { x=x,y=y, w=32,h=32, image=machineIcon })
		
		local rate = f.rate
		if f.idle then rate = 0 end
		table.insert(productTable, { x,y, p.name, rate, p.type.name, p.recipeSize })
		
	else
		table.insert(facTable,
			Text { x=fx,y=0,w=facColWidth,h=fh, label=LabelString(f.port.name), flags=kHAlignCenter+kVAlignTop })
		if f.visited then
			local s = "#"..GetString("factory_forsale_short", bsgDollars(f.price))
			table.insert(facTable,
				Text { x=fx,y=fh+12,w=facColWidth,h=3*fh, label=s, flags=kHAlignCenter+kVAlignTop })
			table.insert(facTable,
				Rollover {
					x=fx,y=rollY, w=facColWidth,h=facH, contents=f:InfoRolloverTarget(),
				})
		end
	end
end

MakeDialog
{
	AppendStyle { font=smallDialogFont },
	Bitmap { x=0,y=0,image="image/ledger_factory" },
	FactoryStatus { x=0,y=0,w=ui.ledgerWidth,h=ui.ledgerHeight,
		bars=columnTable,
		products=productTable,
		colorLoads = GreenColor,	-- Color(50,205,30,255),		-- Color(192,192,192,255), --Color(56,30,209,255),
		colorFull = YellowColor,	-- Color(255,252,15,255),		-- Color(50,205,30,255),
		colorMedium = YellowColor,	-- Color(255,252,15,255),
		colorTrouble = RedColor,	-- Color(255,14,14,255),
	},
	Group(machineTable),
	Group(facTable),
}
